﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TMPro;
using UnityEngine;
using UnityEngine.EventSystems;

public class EndRoundPhase : GamePhase
{
    private Constants.PlayerRole _Winner;
    private int _Round;

    public EndRoundPhase(Constants.PlayerRole winner, int round)
    {
        //Store the winner of the round and the round number itself
        _Winner = winner;
        _Round = round;
    }

    public override void OnStartCurrentPhase()
    {
        //Disable the game updating and pausing, and setup the UI
        Time.timeScale = 0.0f;
        PauseMenu.CanPause = false;
        GameController.Instance.Timer.GetComponent<Animator>().Play("TimerTick", 0, 0);
        GameController.Instance.Timer.GetComponent<Animator>().enabled = false;
        GameController.Instance.Timer.SetActive(false);
        GameController.Instance.RoundResultScreen.SetActive(true);
        GameController.Instance.RoundResultScreen.GetComponent<RoundResultMenu>().MoveToThis(_Winner, _Round);


        if (AudioManager.Instance != null)
        {
            if (AudioManager.Instance.RoundVictoryAudio != null)
            {
                //We've got an audio manager and sound setup, so play the round victory audio
                AudioManager.Instance.PlaySFX(AudioManager.Instance.RoundVictoryAudio);
            }
        }
    }

    public override void Update()
    {

    }

    public override void OnEndCurrentPhase()
    {
        //We're moving onto a new phase now, so reset the hider camera and blend back to the spawn
        GameController.Instance.HiderVirtualCamera.Follow = null;
        GameController.Instance.HiderVirtualCamera.BlendTo(GameController.Instance.SpawnVirtualCamera);
    }
}
